#
# Cookbook:: app_aptly
# Recipe:: default
#
# Copyright:: 2017, Curse, All Rights Reserved.

include_recipe 'base_server_ubuntu'
include_recipe 'sds_aptly'

node.override['poise-python']['options']['pip_version'] = true
python_runtime '2'
python_package "awscli"

if node['aptly']['enable_xenial_mirrors']

  sds_aptly_mirror 'xenial' do
    uri 'http://us.archive.ubuntu.com/ubuntu'
    distribution 'xenial'
    components %w(main restricted universe multiverse)
    key_server 'keys.gnupg.net'
    keys %w(437D05B5 C0B21F32)
  end

  sds_aptly_mirror 'xenial-updates' do
    uri 'http://us.archive.ubuntu.com/ubuntu'
    distribution 'xenial-updates'
    components %w(main restricted universe multiverse)
    key_server 'keys.gnupg.net'
    keys %w(437D05B5 C0B21F32)
  end

  sds_aptly_mirror 'xenial-backports' do
    uri 'http://us.archive.ubuntu.com/ubuntu'
    distribution 'xenial-backports'
    components %w(main restricted universe multiverse)
    key_server 'keys.gnupg.net'
    keys %w(437D05B5 C0B21F32)
  end

  sds_aptly_mirror 'xenial-security' do
    uri 'http://us.archive.ubuntu.com/ubuntu'
    distribution 'xenial-security'
    components %w(main restricted universe multiverse)
    key_server 'keys.gnupg.net'
    keys %w(437D05B5 C0B21F32)
  end

  sds_aptly_merge 'curse-xenial' do
    includes '^xenial-'
    excludes '^xenial-security'
  end

  sds_aptly_merge 'curse-xenial-security' do
    includes '^xenial-security'
  end

end