
$AppPool = "HealthMonitor"

if(!(Test-Path -PathType Container -Path c:\opt\packages)) {
    mkdir c:\opt\packages
}

[Void][Reflection.Assembly]::LoadWithPartialName('System.IO.Compression.FileSystem')
$folder_name = [IO.Compression.ZipFile]::OpenRead("c:\opt\packages\healthmonitor_current.zip").Entries[0].FullName.split('/')[0]

C:\opscode\chef\embedded\bin\unzip.exe -o c:\opt\packages\healthmonitor_current.zip -d c:\opt\packages

if ($folder_name -ne $null) {
  stop-webapppool ${AppPool} -ErrorAction SilentlyContinue
  start-sleep 20
  if (Test-Path -PathType Container -Path c:\inetpub\${AppPool}) {
    mv c:\inetpub\${AppPool} c:\inetpub\${AppPool}_$((get-date).ToString('yyyyMMddHHmmss')) -ErrorAction Stop
  }
  mv c:\opt\packages\${folder_name} c:\inetpub\${AppPool} -ErrorAction Stop
  start-sleep 5
  start-webapppool ${AppPool}

  echo $null >> c:\inetpub\${AppPool}\.chef_deployed
}
