#! /usr/bin/env ruby
# frozen_string_literal: true

require 'sensu/extension/tueor'
require 'influxdb'

module Sensu::Extension
  class InfluxdbFunctionalCheck < TueorCheck

    def name
      'influxdb-functional-check'
    end

    def description
      'Runs a query on influxdb'
    end

    def definition
      {
          :type => "check",
          :name => name
      }
    end

    prep_step(:set_defaults) do
      set :fail_empty, false
    end

    step(:run_query, :status, :message) do
      begin
        influxdb = InfluxDB::Client.new(database, username: username, password: password)
        results = influxdb.query query
        if fail_empty && results.empty?
          set :status, 2
          set :message, "got empty results for query: #{results}"
        else
          set :status, 0
          set :message, results
        end
      rescue => err
        set :status, 2
        set :message, err
      end
    end

    def critical?
      !status.eql? 0
    end

    def warning?
      !status.eql? 0
    end

  end
end