
# Data Filesystem
sds_sensu_extension_check 'data-disk-check' do
  extension 'linux-diskspace-check'
  source 'linux-diskspace-check.rb'
  extension_cookbook 'base_server_ubuntu'
  extra_options({ mountpoint: '/mnt/influxdb_data' })
end

directory '/mnt/influxdb_data/.readonly_fs_test' do
  owner 'sensu'
  mode 0700
end

sds_sensu_extension_check 'data-disk-readonly-check' do
  extension 'linux-disk-readonly-check'
  source 'linux-disk-readonly-check.rb'
  extension_cookbook 'base_server_ubuntu'
  extra_options({ folder: '/mnt/influxdb_data/.readonly_fs_test' })
end


# WAL Filesystem
sds_sensu_extension_check 'wal-disk-check' do
  extension 'linux-diskspace-check'
  source 'linux-diskspace-check.rb'
  extension_cookbook 'base_server_ubuntu'
  extra_options({ mountpoint: '/mnt/influxdb_wal' })
end

directory '/mnt/influxdb_wal/.readonly_fs_test' do
  owner 'sensu'
  mode 0700
end

sds_sensu_extension_check 'wal-disk-readonly-check' do
  extension 'linux-disk-readonly-check'
  source 'linux-disk-readonly-check.rb'
  extension_cookbook 'base_server_ubuntu'
  extra_options({ folder: '/mnt/influxdb_wal/.readonly_fs_test' })
end

# Functional Checks
sds_sensu_gem 'influxdb'

sds_sensu_extension_check 'influxdb-functional-check' do
  extension 'influxdb-functional-check'
  source 'influxdb-functional-check.rb'
  extra_options({
                    database: node['influxdb']['monitoring']['functional']['database'],
                    username: 'cpe',
                    query: node['influxdb']['monitoring']['functional']['query'],
										fail_empty: node['influxdb']['monitoring']['functional']['fail_empty']
                })
  arcana_options({password: 'influxdb_cpe_password'})
  interval 60
  timeout 45
end
