# frozen_string_literal: true

# Cookbook:: app_influxdb
# Recipe:: data
#
# Copyright:: 2017, Curse, All Rights Reserved.
set_role_tag
node.override['influxdb']['data']['config']['hostname'] = node['hostname']

include_recipe 'base_server_ubuntu'
include_recipe "#{cookbook_name}::hosts"

filesystem 'influxdb_data' do
  device node['influxdb']['mounts']['data']
  fstype 'ext4'
  mount '/mnt/influxdb_data'
  action [:create, :enable, :mount]
end

filesystem 'influxdb_wal' do
  device node['influxdb']['mounts']['wal']
  fstype 'ext4'
  mount '/mnt/influxdb_wal'
  action [:create, :enable, :mount]
end

include_recipe 'sds_influxdb::data'

influxdb_database 'cpe_stats' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  action :create
end

influxdb_admin 'cpe' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  password arcana_read('influxdb_cpe_password')
  action [:create, :update]
end

influxdb_user 'sensu' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  password arcana_read('influxdb_sensu_password')
  databases ['cpe_stats']
  action [:create, :update]
end

influxdb_retention_policy 'raw_statistics' do
  auth_username 'cpe'
  auth_password arcana_read('influxdb_cpe_password')
  policy_name 'raw_statistics'
  database 'cpe_stats'
  duration '52w'
  replication 2
  action :create
end

node.override['influxdb']['monitoring']['functional']['database'] = 'cpe_stats'
node.override['influxdb']['monitoring']['functional']['query'] = %w(
  SELECT mean("Average") FROM aws_applicationelb_targetresponsetime WHERE time > now() - 10m
).join(' ')
include_recipe '::data_monitoring'
