
#package "python-pip"
node.override['poise-python']['options']['pip_version'] = true
python_runtime '2'
python_package "awscli"

cookbook_file '/usr/local/bin/consul-ec2-alb' do
  source 'consul-ec2-alb'
  owner 'nomad'
  group 'nomad'
  mode 0700
end

ecr_account = node['nomad']['ecr_url'].split('.').first

# execute 'first-docker-login' do
#   command "eval $(/usr/local/bin/aws --region #{node['nomad']['ecr_region']} ecr get-login --registry-ids #{ecr_account} | sed -e \"s/-e none//\")"
#   retries 5
#   retry_delay 5
#   action :nothing
# end

cron 'docker-login' do
  command "eval $(/usr/local/bin/aws --region #{node['nomad']['ecr_region']} ecr get-login --registry-ids #{ecr_account} | sed -e \"s/-e none//\") > /dev/null"
  minute '0'
  hour '*/8'
  # notifies :run, 'execute[first-docker-login]', :immediately
  action :delete
end

cron 'docker-login-boot' do
  command "eval $(/usr/local/bin/aws --region #{node['nomad']['ecr_region']} ecr get-login --registry-ids #{ecr_account}  | sed -e \"s/-e none//\") > /dev/null"
  time :reboot
  action :delete
end

