return unless node['nomad']['tls']['enabled']

dir = '/opt/hashicorp/nomad/tls'

directory dir do
  owner 'nomad'
  group 'nomad'
  mode 0500
end

%w(ca.pem nomad.pem nomad-key.pem).each do |name|
  file "#{dir}/#{name}" do
    content arcana_read("nomad-tls/#{name}")
    owner 'nomad'
    group 'nomad'
    mode 0400
  end
end

