#!/usr/bin/env bash

if [ "$USE_NEAREST_TAG" ] && [ $USE_NEAREST_TAG -eq 1 ]; then
  IMAGE_VERSION=$(git describe --all --exact-match `git rev-parse HEAD` | sed -e 's#tags/##')
  echo "##teamcity[setParameter name='env.IMAGE_VERSION' value='$IMAGE_VERSION']"
fi

AWS_REPO=$AWS_ECR_URL/$IMAGE_NAME
AWS_ECR_REGION=$(echo $AWS_ECR_URL | perl -F'\.' -lane 'print $F[-3]')

eval $(aws --region $AWS_ECR_REGION ecr get-login | sed -e 's/-e none//')
echo "$AWS_REPO:$IMAGE_VERSION"

echo "Checking Repository in ECR"
aws --region $AWS_ECR_REGION ecr describe-repositories --repository-names $IMAGE_NAME > /dev/null 2>&1

if [ $? -ne 0 ]; then
  echo "Repository doesn't exist, creating it"
  aws --region $AWS_ECR_REGION ecr create-repository --repository-name $IMAGE_NAME
fi

docker tag $IMAGE_NAME $AWS_REPO:$IMAGE_VERSION
docker push $AWS_REPO:$IMAGE_VERSION

if [ "$PUSH_LATEST" ] && [ $PUSH_LATEST -eq 1 ]; then
    docker tag $IMAGE_NAME $AWS_REPO:latest
    docker push $AWS_REPO:latest
fi
