set_role_tag
include_recipe 'base_server_ubuntu'
include_recipe 'sds_teamcity::agent'

node['teamcity']['agent_partials'].each do |agent|
  include_recipe "#{cookbook_name}::#{agent}_partial"
end

directory '/opt/jetbrains/TeamCity/.ssh' do
  owner 'teamcity'
  group 'teamcity'
  mode 0700
end

file '/opt/jetbrains/TeamCity/.ssh/twitch-ghe-read-key' do
  content arcana_read('twitch-ghe-read-key')
  owner 'teamcity'
  group 'teamcity'
  mode 0600
  sensitive true
end

file '/opt/jetbrains/TeamCity/.ssh/config' do
  content <<-EOF
Host git-aws.internal.justin.tv
  StrictHostKeyChecking no
  UserKnownHostsFile=/dev/null
  HostName git-aws.internal.justin.tv
  IdentityFile ~/.ssh/twitch-ghe-read-key

Host git.xarth.tv
  StrictHostKeyChecking no
  UserKnownHostsFile=/dev/null
  HostName git.xarth.tv
  IdentityFile ~/.ssh/twitch-ghe-read-key
  EOF
  owner 'teamcity'
  group 'teamcity'
  mode 0600
end

cron 'teamcity-cleanup' do
  command '/usr/bin/find /opt/jetbrains/TeamCity_agent/work/.old  -maxdepth 1 -mtime +2 -exec rm -rf "{}" +'
  hour '2'
end

cron 'fix-root-files' do
  command '/usr/bin/find /opt/jetbrains/TeamCity_agent/work -not -user teamcity -exec chown teamcity:teamcity "{}" \;'
end

cron 'fix-root-files-faster' do
  command 'sleep 30; /usr/bin/find /opt/jetbrains/TeamCity_agent/work -not -user teamcity -exec chown teamcity:teamcity "{}" \;'
end

# directory '/etc/systemd/system/sensu-client.service.d' do
#   recursive true
#   action node['sensu']['systemd']['niceness'] != 0 ? :create : :delete
# end

# template '/etc/systemd/system/sensu-client.service.d/override.conf' do
#   source 'sensu-client.service.override.conf.erb'
#   mode 00644
#   helper(:sensu) { node['sensu'] }
#   notifies :run, 'execute[systemctl daemon-reload]', :immediately
#   notifies :restart, 'service[sensu-client]', :delayed
#   action node['sensu']['systemd']['niceness'] != 0 || node['sensu']['systemd']['oom_score_adjust'] != 0 ? :create : :delete
# end
