tag 'teamcity_docker_agent'
node.default['teamcity']['agent']['env_properties']['DOCKER_AGENT'] = 1
node.default['teamcity']['agent']['env_properties']['DOCKER_HOST'] = 'unix:///var/run/docker.sock'

execute 'update-grub' do
  command '/usr/sbin/update-grub'
  action :nothing
end

file '/etc/grub.d/99-docker.cfg' do
  content 'GRUB_CMDLINE_LINUX_DEFAULT="${GRUB_CMDLINE_LINUX_DEFAULT} cgroup_enable=memory swapaccount=1"'
  owner 'root'
  group 'root'
  mode '0644'
  notifies :run, 'execute[update-grub]', :immediately
end

apt_repository 'docker-stable' do
  arch 'amd64'
  uri "https://download.docker.com/linux/#{node['platform']}"
  distribution node['lsb']['codename']
  components %w(stable)
  keyserver 'keyserver.ubuntu.com'
  key '9DC858229FC7DD38854AE2D88D81803C0EBFCD88'
  action :nothing
end.run_action(:add)

docker_service 'default' do
  install_method 'package'
  # version '17.12.0'
  version '18.06.1'
  package_version '18.06.1~ce~3-0~ubuntu' if node['platform'] == 'ubuntu' # issue because we're not on a more up to date docker cookbook
  dns ['169.254.169.253']

  host ['unix:///var/run/docker.sock', 'tcp://0.0.0.0:2376']
  systemd_opts ['TasksMax=infinity', 'MountFlags=private']
  action [:create, :start]
end

# TODO: we should mirror this locally
remote_file '/usr/local/bin/docker-compose' do
  source 'https://github.com/docker/compose/releases/download/1.23.1/docker-compose-Linux-x86_64'
  owner 'root'
  group 'root'
  mode '0755'
  action :create
end

group 'docker' do
  action :modify
  members 'teamcity'
  append true
end


# If pip was upgraded to 18.1 we need to downgrade it to unbrick chef.
execute 'downgrade_pip' do
  command 'pip install pip==18.0'
  only_if 'command -v pip && pip --version | grep -q 18.1'
end

python_runtime '2'
python_package 'awscli'

package 'ruby'
package 'ruby-dev'
package 'libxslt-dev'
package 'libxml2-dev'
package 'zlib1g-dev'

%w(faraday faraday_middleware nokogiri rest-client).each do |gem|
  gem_package gem
end

gem_package 'aws-sdk' do
  version '2.11.474'
end

chef_gem 'aws-sdk' do
  version '2.11.474'
end

cookbook_file '/usr/local/bin/docker-clean' do
  source 'docker-clean'
  mode '0755'
end

cookbook_file '/usr/local/bin/nomad' do
  source 'nomad'
  mode '0755'
end

cookbook_file '/usr/local/bin/ecr_auth.sh' do
  source 'ecr_auth.sh'
  mode '0755'
end

cookbook_file '/usr/local/bin/ecr_push.sh' do
  source 'ecr_push.sh'
  mode '0755'
end

cron 'docker-clean' do
  command '/usr/local/bin/docker-clean > /dev/null 2>&1'
  minute '0'
end
