tag 'teamcity_selenium_agent'
node.default['teamcity']['agent']['env_properties']['SELENIUM_AGENT'] = 1

user 'selenium' do
  username 'selenium'
  manage_home true
  shell '/bin/bash'
  home '/home/selenium'
  system true
end

node.override['xvfb']['dimensions'] = "1024x768x24"
node.override['xvfb']['args'] = '-ac'
include_recipe 'xvfb'

# track = 'stable'

apt_repository 'google-chrome' do
  arch 'amd64'
  uri 'http://dl.google.com/linux/chrome/deb'
  distribution 'stable'
  components %w(main)
  key 'https://dl-ssl.google.com/linux/linux_signing_key.pub'
  action :nothing
end.run_action(:remove)

# package "google-chrome-#{track}" do
#   action :nothing
#   version node['teamcity']['agent']['chrome']['version']
# end.run_action(:install)
#
# package "google-chrome-beta" do
#   action :nothing
#   version node['teamcity']['agent']['chrome']['version']
# end.run_action(:purge)
#
# execute 'set chrome channel' do
#   command "update-alternatives --set google-chrome /usr/bin/google-chrome-#{track}"
#   not_if "update-alternatives --display google-chrome | grep \"link currently points\" |grep -q /usr/bin/google-chrome-#{track}"
# end

google_chrome_key = format(node['teamcity']['agent']['chrome']['s3']['key'], node['teamcity']['agent']['chrome']['version'])
s3_file "/cpe/packages/#{File.basename(google_chrome_key)}" do
  key google_chrome_key
  checksum node['teamcity']['agent']['chrome']['checksum']
  mode 0644
  not_if { File.exist? "/cpe/packages/#{File.basename(google_chrome_key)}" }
end

package 'fonts-liberation'
package 'gconf-service'
package 'libappindicator1'
package 'libasound2'
package 'libatk-bridge2.0-0'
package 'libatk1.0-0'
package 'libcairo2'
package 'libcups2'
package 'libfontconfig1'
package 'libnspr4'
package 'libnss3'
package 'libxss1'
package 'xdg-utils'

# Korean/Japanese/Chinese Fonts
package 'fonts-noto-cjk'
package 'fonts-thai-tlwg' do
  action :remove
end
package 'fonts-tlwg-laksaman-ttf'

package 'google-chrome-stable' do
  source "/cpe/packages/#{File.basename(google_chrome_key)}"
  provider Chef::Provider::Package::Dpkg
  action [:install]
  not_if "[ $(dpkg-query --showformat='${Version}' --show google-chrome-stable) == \"#{node['teamcity']['agent']['chrome']['version']}\" ]"
end

include_recipe 'chromedriver'
include_recipe 'selenium'

%w(log run).each do |dir|
  directory "/opt/selenium/#{dir}" do
    owner 'selenium'
    group 'selenium'
  end
end

cookbook_file '/etc/systemd/system/selenium.service' do
  source 'selenium.service'
  mode 0700
end

service 'selenium' do
  action [:start, :enable]
end

sudo 'selenium' do
  user "teamcity"
  runas 'root'
  nopasswd true
  commands [
               '/etc/init.d/selenium stop',
               '/etc/init.d/selenium start',
               '/usr/bin/pkill -f chrome',
               '/usr/sbin/service selenium stop',
               '/usr/sbin/service selenium start'
           ]
end

# hostsfile_entry '127.0.0.1' do
#   hostname 'localhost'
#   aliases ['teamcity-localhost.twitch.tv', 'teamcitycdn-localhost.twitch.tv']
#   action :append
# end
