set_role_tag
include_recipe 'base_server_ubuntu'
include_recipe 'sds_teamcity::server'

directory '/opt/jetbrains/TeamCity/.ssh' do
  owner 'teamcity'
  group 'teamcity'
  mode 0700
end

file '/opt/jetbrains/TeamCity/.ssh/twitch-ghe-read-key' do
  content arcana_read('twitch-ghe-read-key')
  owner 'teamcity'
  group 'teamcity'
  mode 0600
  sensitive true
end

file '/opt/jetbrains/TeamCity/.ssh/config' do
  content <<-EOF
Host git-aws.internal.justin.tv
  StrictHostKeyChecking no
  UserKnownHostsFile=/dev/null
  HostName git-aws.internal.justin.tv
  IdentityFile ~/.ssh/twitch-ghe-read-key
  EOF
  owner 'teamcity'
  group 'teamcity'
  mode 0600
end
