# `app_teamcity_agent_macos`


## Getting set up to work on this repo

Follow the instructions [here](https://git.xarth.tv/CPE-Ops/cpe-core)


Get vagrant/vmware set up - https://www.vagrantup.com/docs/vmware/installation.html

You'll need to purchase a license for the vagrant-vmware-provider

Undocumented step in the above instructions: Install [VMware Fusion](https://www.vmware.com/products/fusion/fusion-evaluation.html)

Then make sure the vagrant-vmware-utility is working correctly

```
$ sudo launchctl list | grep com.vagrant.vagrant-vmware-utility
-	0	com.vagrant.vagrant-vmware-utility-stopper
6696	1	com.vagrant.vagrant-vmware-utility

# Logs are here for the utility:
sudo tail -f /Library/Application\ Support/vagrant-vmware-utility/service.log
```

Then download the MacOS 10.13 and 10.14 *vmware.box files [here](https://www.dropbox.com/sh/uyi5ctvzghpo4f9/AAAuVzk742iNH8MncFfZEAgoa?dl=0)
Place those *.box files at:

*  `macos_10.14_vmware.box` --> `cpe-core/cookbooks/app_teamcity_agent_macos/.kitchen/kitchen-vagrant/desktop-desklight-agent-macos-1014/macos-10.14`
*  `macos_10.13_vmware.box` --> `cpe-core/cookbooks/app_teamcity_agent_macos/.kitchen/kitchen-vagrant/desktop-desklight-agent-macos-1013/macos-10.13`

## Dependencies

To run test kitchen on this repo, you'll need a secret set up

```
cd cpe-core/cookbooks/app_teamcity_agent_macos/

# Put the secret "test_kitchen_databag_secret 2" from the 1password vault "Mac Agent Cookbook Dev" into this file:
nano ../../kitchen/test_kitchen_databag_secret
```

## Final Steps for test-kitchen

DISABLE TELEPORT-BASTION

`teleport-bastion disable`

GET OFF WPA2


## Troubleshooting

Problem while running `kitchen converge`:

```
>>>>>>     Failed to complete #converge action: [execution expired] on desktop-agent-windows-2016-vs2017
```

Solution: Get new credentials out of Isengard


## Uploading your cookbook

Follow the instructions [here](https://git.xarth.tv/CPE-Ops/cpe-core#uploading-your-cookbook)
