cask 'mono-mdk' do
    version '5.10.1.47'
    sha256 '6ae1d3ee267cb567561052e230aff40eefc9bc5418970a89b5cfd4f0f13eec33'
  
    url "https://download.mono-project.com/archive/#{version.major_minor_patch}/macos-10-universal/MonoFramework-MDK-#{version}.macos10.xamarin.universal.pkg"
    appcast 'https://xampubdl.blob.core.windows.net/static/installer_assets/v3/Mac/Universal/InstallationManifest.xml',
            checkpoint: '0ce41f30dfa6fddbe9f848145061b96f9e6293b9e6325b114547946b68eb293f'
    name 'Mono'
    homepage 'http://www.mono-project.com/'
  
    pkg "MonoFramework-MDK-#{version}.macos10.xamarin.universal.pkg"
  
    uninstall delete:  [
                         "/Library/Frameworks/Mono.framework/Versions/#{version.major_minor_patch}",
                         '/private/etc/paths.d/mono-commands',
                       ],
              pkgutil: 'com.xamarin.mono-*',
              rmdir:   [
                         '/Library/Frameworks/Mono.framework/Versions',
                         '/Library/Frameworks/Mono.framework',
                       ]
  
    caveats <<~EOS
      Installing #{token} removes mono and mono dependant formula binaries in
      /usr/local/bin and adds #{token} to /private/etc/paths.d/
      You may want to:
  
        brew unlink {formula} && brew link {formula}
  
      and/or remove /private/etc/paths.d/mono-commands
    EOS
  end