cask 'visual-studio' do
    version '7.5.3.7'
    sha256 '901765a3654641a6a8efe4eb5c94e8c1b67a179f67463870f280dfa18e9ffcc2'
  
    # dl.xamarin.com/VsMac was verified as official when first introduced to the cask
    url "https://dl.xamarin.com/VsMac/VisualStudioForMac-#{version}.dmg"
    appcast 'https://xampubdl.blob.core.windows.net/static/installer_assets/v3/vsmac/Mac/Universal/InstallationManifest.xml'
    name 'Visual Studio for Mac'
    homepage 'https://www.visualstudio.com/vs/visual-studio-mac/'
  
    depends_on cask: 'mono-mdk'
  
    app 'Visual Studio.app'
  
    zap trash: [
                 '/Applications/Xamarin Workbooks.app',
                 '/Applications/Xamarin Profiler.app',
                 '~/Library/Application Support/VisualStudio',
                 '~/Library/Application Support/CrashReporter/VisualStudio*',
                 '~/Library/Caches/VisualStudio',
                 '~/Library/Logs/VisualStudio',
                 '~/Library/Preferences/Visual*Studio',
                 '~/Library/Preferences/Xamarin',
                 '~/Library/Developer/Xamarin',
                 '~/Library/VisualStudio',
               ]
  end