node.override['teamcity']['agent']['user_password'] = chef_vault_item('system', 'teamcity_user')[:password]
node.override['teamcity']['agent']['user_token'] = chef_vault_item('system', 'teamcity_user')[:token]

include_recipe 'sds_teamcity::agent'

group '_developer' do
  action :modify
  members 'teamcity'
  append true
end

group 'homebrew' do
  action :modify
  members 'teamcity'
  append true
end

directory "#{node['teamcity']['agent']['home_dir']}/.ssh" do
  owner 'teamcity'
  group 'teamcity'
  mode 0700
end

github = chef_vault_item('github', 'read_only')

file "#{node['teamcity']['agent']['home_dir']}/.ssh/twitch-ghe-read-key" do
  content github[:key]
  owner 'teamcity'
  group 'teamcity'
  mode 0600
end

file "#{node['teamcity']['agent']['home_dir']}/.ssh/config" do
  content <<-EOF
Host git-aws.internal.justin.tv
  StrictHostKeyChecking no
  UserKnownHostsFile=/dev/null
  HostName git-aws.internal.justin.tv
  IdentityFile ~/.ssh/twitch-ghe-read-key
Host git.xarth.tv
  StrictHostKeyChecking no
  UserKnownHostsFile=/dev/null
  HostName git.xarth.tv
  IdentityFile ~/.ssh/twitch-ghe-read-key
  EOF
  owner 'teamcity'
  group 'teamcity'
  mode 0600
end

# Install Sandstorm
# Won't work until we can access GitHub

# homebrew_tap 'twitch/internal' do
#   url 'git@git-aws.internal.justin.tv:common/homebrew-custom.git'
# end

# homebrew_package 'twitch/internal/sandstorm'

cookbook_file '/usr/local/bin/sandstorm' do
  source 'sandstorm_binary'
  mode 0755
end

execute 'gem install faraday' do
  command '/usr/bin/gem install faraday -q -N -v "0.15.4" --source=https://www.rubygems.org'
end

execute 'gem install faraday_middleware' do
  command '/usr/bin/gem install faraday_middleware -q -N -v "0.13.1" --source=https://www.rubygems.org'
end

homebrew_package 'git-lfs'

execute 'git-enable-lfs' do
  command 'sudo /usr/bin/git lfs install --system'
  user node['homebrew']['owner']
  environment ({
      'HOME' => "/Users/#{node['homebrew']['owner']}",
      'USER' => node['homebrew']['owner'],
      'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    })
end

execute 'git-set-user-email' do
  command '/usr/bin/git config --global user.email "csi-devops@justin.tv"'
end

execute 'git-set-user-name' do
  command '/usr/bin/git config --global user.name "CSI TeamCity"'
end
