tag 'teamcity_androidsdk_agent'
node.default['teamcity']['agent']['env_properties']['ANDROIDSDK_AGENT'] = 1

homebrew_tap 'homebrew/cask'
# From homebrew 2.7, calling "brew cast install" command is deprecated,
# we're using calling a bash command instead. Rollback when homebrew_cast
# adopt the new change.
#
#homebrew_cask 'android-sdk' do
#  install_cask false
#end
bash 'android-sdk' do
  code 'brew  install --cask android-sdk'
  environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
  user node['homebrew']['owner']
end

# Pinning in Homebrew is crappy, we should probably have our own Homebrew Keg/Cask repos
# Android-NDK v16b Cask
directory "/Users/#{node['homebrew']['owner']}/casks" do
    owner node['homebrew']['owner']
  end
  
%w( android-ndk ).each do |name|
    cookbook_file "/Users/#{node['homebrew']['owner']}/casks/#{name}.rb" do
      source "casks/#{name}.rb"
    end
  
    execute "install #{name}" do
        command "/usr/local/bin/brew install --cask /Users/#{node['homebrew']['owner']}/casks/#{name}.rb"
        user node['homebrew']['owner']
        environment ({
            'HOME' => "/Users/#{node['homebrew']['owner']}",
            'USER' => node['homebrew']['owner'] 
        })
        only_if "brew info --cask #{name} | grep -q 'Not installed'"
    end
end
  
file '/etc/profile.d/android-sdk.sh' do
    content <<-EOH
    export ANDROID_HOME=/usr/local/share/android-sdk
    export ANDROID_NDK_HOME=/usr/local/share/android-ndk
    export PATH=$PATH:$ANDROID_HOME:$ANDROID_HOME/tools:$ANDROID_HOME/platform-tools:$ANDROID_NDK_HOME
    EOH
    mode 0755
end

bash 'accept_sdk_licenses' do
    code 'yes | sdkmanager --licenses'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
end

apis = %w(
    platforms;android-16
    platforms;android-19
    platforms;android-21
    platforms;android-22
    platforms;android-23
    platforms;android-24
    platforms;android-25
    platforms;android-26
    platforms;android-27
    platforms;android-28
    platforms;android-29
).each do |api_level| 
    bash "install_#{api_level.gsub(/;/, '_')}" do
        code "sdkmanager \"#{api_level}\""
        environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    end 
end
