set_role_tag

include_recipe 'base_server_macos'
include_recipe '::agent'
node.default['xcode']['install_version'] = '10.3'
include_recipe '::xcode_partial'
include_recipe '::xamarin_partial'

sudo "teamcity_hdutil" do
    user "teamcity"
    commands ['/usr/bin/hdiutil', '/usr/sbin/bless']
    nopasswd true
end

keychain_cert 'dist-macos-ci' do
    cert_content Base64.strict_decode64(chef_vault_item('desktop', 'macos_prod')[:pem])
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash 'ABFB5A2AD6A91F14F5C7E7C5B567FA7E5FC61FCC'
end

# Set up password for TWITCH_DESKTOP_AGENT_AC_PASSWORD
execute 'Delete keychain entry if it exists and the password does not match what is in the databag' do
    command 'if security find-generic-password -s TWITCH_DESKTOP_AGENT_AC_PASSWORD /Library/Keychains/System.keychain > /dev/null 2>/dev/null ; \
                then if [ ! $(security find-generic-password -s TWITCH_DESKTOP_AGENT_AC_PASSWORD -w /Library/Keychains/System.keychain) == "' + chef_vault_item('desktop', 'twitch_desktop_agent_ac_password')[:password] + '" ] ; then \
                     sudo security delete-generic-password -s TWITCH_DESKTOP_AGENT_AC_PASSWORD /Library/Keychains/System.keychain ; \
                fi ; \
            fi'
    action :run
    sensitive true
end

twitch_desktop_agent_ac_password_username = 'desktop-mac-agent@justin.tv'
execute 'Add TWITCH_DESKTOP_AGENT_AC_PASSWORD to System keychain' do
    command 'if ! security find-generic-password -s TWITCH_DESKTOP_AGENT_AC_PASSWORD  -a ' + twitch_desktop_agent_ac_password_username + '> /dev/null 2>/dev/null ; then \
                security add-generic-password -a ' + twitch_desktop_agent_ac_password_username + ' -s TWITCH_DESKTOP_AGENT_AC_PASSWORD -w ' + chef_vault_item('desktop', 'twitch_desktop_agent_ac_password')[:password] + ' \
                -T /Applications/Xcode.app/Contents/Applications/Application\ Loader.app/Contents/Frameworks/ITunesSoftwareService.framework/Versions/A/Support/altool -T /usr/bin/security /Library/Keychains/System.keychain ; \
            fi'
    action :run
    sensitive true
end

# Use Sandstorm to set up Twitch Desktop Developer ID Certificate
# Grab AWS credentials to access Sandstorm secrets
aws_desktop_sandstorm_creds = chef_vault_item('desktop', 'sandstorm_creds')

directory '/opt/jetbrains/TeamCity/.aws' do
    owner 'teamcity'
    group 'teamcity'
    mode 0700
end

file '/opt/jetbrains/TeamCity/.aws/credentials' do
    owner 'teamcity'
    group 'teamcity'
    mode 0600
    content <<~EOH
        [desktop-sandstorm]
        aws_access_key_id = #{aws_desktop_sandstorm_creds[:access_key]}
        aws_secret_access_key = #{aws_desktop_sandstorm_creds[:secret_key]}
    EOH
    sensitive true
end

# Use the installed  Sandstorm CLI to grab the cert.
# Not using the Ruby API since it doesn't work correctly to grab a binary secret
# out of Sandstorm.
execute 'Use Sandstorm CLI to grab signing certificate' do
    command 'sudo -u teamcity -i bash -c \
        "/usr/local/bin/sandstorm get --profile desktop-sandstorm \
        --role-arn arn:aws:iam::734326455073:role/sandstorm/production/templated/role/twitch-desktopapp-macbuildagent \
        desktop-signers/twitch-desktop-app/production/mac.twitch.code.sign.p12 > /tmp/signing_cert.p12"'
    action :run
end

keychain_cert 'Twitch-Desktop-Developer-ID-Certificate' do
    cert_content lazy { File.read("/tmp/signing_cert.p12") }
    cert_password chef_vault_item('desktop', 'desktop_cert')[:password]
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash '3412C01D08282D56BEC60E747D98ABE97876DF6E'
end
