set_role_tag

aws_ios_prod = chef_vault_item('aws', 'ios_prod')
aws_ios_dev = chef_vault_item('aws', 'ios_dev')

include_recipe 'base_server_macos'
include_recipe '::agent'
include_recipe '::rbenv_partial'
node.default['xcode']['install_version'] = '10.0'
include_recipe '::xcode_partial'

directory '/opt/jetbrains/TeamCity/.aws' do
    owner 'teamcity'
    group 'teamcity'
    mode 0700
end

file '/opt/jetbrains/TeamCity/.aws/credentials' do
    owner 'teamcity'
    group 'teamcity'
    mode 0600
    content <<-EOH
[ios-dev]
aws_access_key_id = #{aws_ios_dev[:access_key]}
aws_secret_access_key = #{aws_ios_dev[:secret_key]}
 
[ios-prod]
aws_access_key_id = #{aws_ios_prod[:access_key]}
aws_secret_access_key = #{aws_ios_prod[:secret_key]}
    EOH
end


prod_client = ::Sandstorm::Client.new(
    role_arn: 'arn:aws:iam::734326455073:role/sandstorm/production/templated/role/ios-prod',
    access_key: aws_ios_prod[:access_key],
    secret_key: aws_ios_prod[:secret_key]
)

dev_client = Sandstorm::Client.new(
    role_arn: 'arn:aws:iam::734326455073:role/sandstorm/production/templated/role/ios-dev',
    access_key: aws_ios_dev[:access_key],
    secret_key: aws_ios_dev[:secret_key]
)

keychain_cert 'dev-ios-ci' do
    cert_content dev_client.get_secret_plaintext('platforms/Apple/development/ios-ci@justin.tv/pem')
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash 'D4A4953957A29EB00C2C6525050379DF74C80965'
end

keychain_cert 'dev-enterprise-ios-ci' do
    cert_content dev_client.get_secret_plaintext('platforms/Apple/development/enterprise/ios-ci@justin.tv/pem')
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash '937F73658DF8A896B8F2797C7EB995B6201F2828'
end

keychain_cert 'dist-ios-ci' do
    cert_content prod_client.get_secret_plaintext('platforms/Apple/production/distribution/twitch-interactive-inc/pem')
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash '4444F715D5D40AF06C1430907082B5CDD0917715'
end

keychain_cert 'dist-enterprise-ios-ci' do
    cert_content prod_client.get_secret_plaintext('platforms/Apple/production/distribution/enterprise/twitch-interactive-inc/pem')
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash '192B9D67CC9E9363FB1C2482977C2F6150835149'
end
