set_role_tag

aws_tvapps_prod = chef_vault_item('aws', 'tvapps_prod')

include_recipe 'base_server_macos'
include_recipe '::agent'

directory '/opt/jetbrains/TeamCity/.aws' do
    owner 'teamcity'
    group 'teamcity'
    mode 0700
end

file '/opt/jetbrains/TeamCity/.aws/credentials' do
    owner 'teamcity'
    group 'teamcity'
    mode 0600
    content <<-EOH
[tvapps-prod]
aws_access_key_id = #{aws_tvapps_prod[:access_key]}
aws_secret_access_key = #{aws_tvapps_prod[:secret_key]}
    EOH
end

include_recipe '::androidsdk_partial'

bash 'get_pip' do
    code 'easy_install pip'
    not_if { File.exists?('/usr/local/bin/pip') }
end

bash 'pip_GitPython' do
    code 'pip install GitPython'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    # not_if { File.exists?('/usr/local/bin/pip') }
end

homebrew_package 'ruby'

brew_deps = {
    'cmake'=> '3.12.2',
    'ninja'=> '1.8.2',
    'node'=> '10.11.0',
    'ruby-build'=> '20180822',
    'yarn'=> '1.9.4'
}

brew_deps.each do |package, version|
    homebrew_package package do
        version version
    end
end

# Ignore the launchctl error here
# homebrew_package 'watchman' do
#     version '2.9.0'
#     ignore_failure true
#     notifies :request_reboot, 'reboot[reboot]', :delayed
# end

bash 'yarn-react-native' do
    code 'yarn global add create-react-native-app'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    # not_if { File.exists?('/usr/local/bin/pip') }
end

bash 'yarn-youi-cli' do
    code 'yarn global add youi-cli@2.2.7'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    # not_if { File.exists?('/usr/local/bin/pip') }
end

reboot 'reboot' do
  action :nothing
  reason 'Request reboot'
  delay_mins 5
end
