set_role_tag

aws_tvapps_prod = chef_vault_item('aws', 'tvapps_prod')
aws_tvapps_dev = chef_vault_item('aws', 'tvapps_dev')

include_recipe 'base_server_macos'
include_recipe '::agent'

directory '/opt/jetbrains/TeamCity/.aws' do
    owner 'teamcity'
    group 'teamcity'
    mode 0700
end

file '/opt/jetbrains/TeamCity/.aws/credentials' do
    owner 'teamcity'
    group 'teamcity'
    mode 0600
    content <<~EOH
        [tvapps-dev]
        aws_access_key_id = #{aws_tvapps_dev[:access_key]}
        aws_secret_access_key = #{aws_tvapps_dev[:secret_key]}

        [tvapps-prod]
        aws_access_key_id = #{aws_tvapps_prod[:access_key]}
        aws_secret_access_key = #{aws_tvapps_prod[:secret_key]}
    EOH
end

node.default['xcode']['install_version'] = '11.3.1'
include_recipe '::xcode_partial'

include_recipe '::tvos_partial'
include_recipe '::androidsdk_partial'

bash 'get_pip' do
    code 'easy_install pip'
    not_if { File.exists?('/usr/local/bin/pip') }
end

bash 'pip_GitPython' do
    code 'pip install GitPython'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
end

rbenv_system_install 'rbenv_install'
rbenv_ruby '2.5.1'
rbenv_global '2.5.1'

rbenv_gem 'bundler' do
    rbenv_version '2.5.1'
end

rbenv_gem 'fastlane' do
    version '2.166.0'
    rbenv_version '2.5.1'
end

rbenv_gem 'faraday' do
    version '0.15.4'
    rbenv_version '2.5.1'
end

rbenv_gem 'faraday_middleware' do
    version '0.13.1'
    rbenv_version '2.5.1'
end

rbenv_rehash 'rehash'

brew_deps = {
    'cmake'=> '3.16.0',
    'ninja'=> '1.8.2',
    'node'=> '10.11.0',
    'python'=> '3.9.1_5',
    'yarn'=> '1.19.2'
}

brew_deps.each do |package, package_version|
    homebrew_package package do
        version package_version
        notifies :request_reboot, 'reboot[reboot]'
    end
end

# Ignore the launchctl error here
homebrew_package 'watchman' do
    version '4.9.0_3'
    ignore_failure true
    notifies :request_reboot, 'reboot[reboot]', :delayed
end

bash 'pip3_requests' do
    code 'pip3 install requests'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
end

bash 'yarn-react-native' do
    code 'yarn global add create-react-native-app'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    # not_if { File.exists?('/usr/local/bin/pip') }
end

bash 'yarn-youi-cli' do
    code 'yarn global add youi-cli@2.3.2'
    environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
    # not_if { File.exists?('/usr/local/bin/pip') }
end

reboot 'reboot' do
  action :nothing
  reason 'Request reboot'
  delay_mins 5
end

dev_client = ::Sandstorm::Client.new(
    role_arn: 'arn:aws:iam::734326455073:role/sandstorm/production/templated/role/tvapps-dev',
    access_key: aws_tvapps_dev[:access_key],
    secret_key: aws_tvapps_dev[:secret_key]
)

prod_client = ::Sandstorm::Client.new(
    role_arn: 'arn:aws:iam::734326455073:role/sandstorm/production/templated/role/tvapps-prod',
    access_key: aws_tvapps_prod[:access_key],
    secret_key: aws_tvapps_prod[:secret_key]
)

keychain_cert 'dist-tvos-ci' do
    cert_content prod_client.get_secret_plaintext('platforms/Apple/production/distribution/twitch-interactive-inc/pem')
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash prod_client.get_secret_plaintext('platforms/Apple/production/distribution_identity_hash')
end

keychain_cert 'dist-tvos-ci-dev' do
    cert_content dev_client.get_secret_plaintext('platforms/Apple/development/ios-ci@justin.tv/pem')
    apps ['/usr/bin/codesign', '/usr/bin/security']
    keychain '/Library/Keychains/System.keychain'
    identity_hash dev_client.get_secret_plaintext('platforms/Apple/development/development_identity_hash')
end
