tag 'teamcity_xamarin_agent'
node.default['teamcity']['agent']['env_properties']['XAMARIN_AGENT'] = 1

# Pinning in Homebrew is crappy, we should probably have our own Homebrew Keg/Cask repos
directory "/Users/#{node['homebrew']['owner']}/casks" do
  owner node['homebrew']['owner']
end

%w( mono-mdk visual-studio xamarin-mac ).each do |name|
  cookbook_file "/Users/#{node['homebrew']['owner']}/casks/#{name}.rb" do
    source "casks/#{name}.rb"
  end

  execute "install #{name}" do
    command "/usr/local/bin/brew cask install /Users/#{node['homebrew']['owner']}/casks/#{name}.rb"
    user node['homebrew']['owner']
    environment ({
        'HOME' => "/Users/#{node['homebrew']['owner']}",
        'USER' => node['homebrew']['owner'] 
    })
    only_if "brew cask info #{name} | grep -q 'Not installed'"
  end
end

cookbook_file '/var/root/main.swift' do
  source 'MonoFixer.swift'
  mode 0755
  notifies :run, 'execute[fix mono libs]', :immediately
end

execute 'fix mono libs' do
  action :nothing
  command '/usr/bin/swift /var/root/main.swift'
end

homebrew_package 'node@12' do
  version '12.14.0'
end

%w( node@12 ).each do |target|
  execute "fix #{target} linking" do
    command "/usr/local/bin/brew unlink #{target} && /usr/local/bin/brew link --force #{target}"
    user node['homebrew']['owner']
    environment ({
        'HOME' => "/Users/#{node['homebrew']['owner']}",
        'USER' => node['homebrew']['owner'] 
    })
  end
end

execute 'install yarn' do
  command 'npm install -g yarn'
  environment 'PATH' => "/usr/local/bin:#{ENV['PATH']}"
end
