tag 'teamcity_xcode_agent'
node.default['teamcity']['agent']['env_properties']['XCODE_AGENT'] = 1
node.default['teamcity']['agent']['env_properties']['XCODE_VERSION'] = node['xcode']['install_version'] || '10.0'

include_recipe 'ruby_build'

apple_id = chef_vault_item('apple', 'id')
node.default['macos']['apple_id']['user'] = apple_id[:user]
node.default['macos']['apple_id']['password'] = apple_id[:password]

xcode node['xcode']['install_version'] || '10.0' do
  not_if { File.exists?('/usr/bin/xcodebuild') && `/usr/bin/xcodebuild -version`.include?(node['xcode']['install_version']) }
end
