require 'tempfile'

resource_name :keychain_cert

property :cert_content, String
property :cert_password, String
property :keychain, String
property :apps, Array
property :identity_hash, String, required: true

default_action :install

action_class do
  def keychain
    new_resource.property_is_set?(:keychain) ? new_resource.keychain : ''
  end

  def cert_password
    new_resource.property_is_set?(:cert_password) ? new_resource.cert_password : ''
  end
end

load_current_value do

end

action :install do

  tempfile = Tempfile.new([new_resource.name, '.p12'])
  tempfile.write new_resource.cert_content
  tempfile.close

  puts tempfile.path

  cert = SecurityCommand.new(tempfile.path, keychain)

  execute 'install-certificate' do
    command [*cert.install_certificate(cert_password, new_resource.apps)]
    not_if "/usr/bin/security find-identity |grep -q #{new_resource.identity_hash}"
    sensitive true
  end

end