#!/bin/bash

set -euo pipefail
#set -x

AWSCLI="$(which aws || true)"
JQ="$(which jq || true)"
BERKS="$(which berks || true)"
BASE_DIR="$(git rev-parse --show-toplevel)"
LOCAL_DEPLOY_PATH="${BASE_DIR}/chef-solo"
DEPLOY_BUCKET='s3://generic-packages-default-uswest2-6d6c0de383565712c723c750188799/chef-solo/app_teamcity_agent_windows'
DEPLOY_ARTIFACT_NAME="cookbooks-$(date +%s).tar.gz"
DEPLOY_ARTIFACT_PATH="${BASE_DIR}/${DEPLOY_ARTIFACT_NAME}"
DEPLOY_S3_ARTIFACT="${DEPLOY_BUCKET}/${DEPLOY_ARTIFACT_NAME}"
BERKSFILE_PATH="${BASE_DIR}/Berksfile"
INTERNAL_COOKBOOK_SOURCE='git@git.xarth.tv:CPE-Chef'
INTERNAL_COOKBOOKS='base_server_windows lib_cpe sds_teamcity'
export AWS_PROFILE="${AWS_PROFILE:-cpe-tools}"

cd "${BASE_DIR}"

function test_prereqs() {
  if [[ -z $AWSCLI || -z $JQ || -z $BERKS ]]; then
    echo -e "\n\nYou must have aws cli, jq, and berks installed and in your path\n\n"
    exit 1
  fi
  echo 'Prereqs validated'
}

function test_aws_permissions() {
  # Make sure we can write to the deploy bucket
  if [[ $($AWSCLI s3 cp README.md ${DEPLOY_BUCKET}/test.txt --dryrun >/dev/null 2>&1) -ne 0 ]]; then
    echo 'ERROR: You must have permission to write to the following s3 bucket in the cpe-tools account:'
    echo "${DEPLOY_BUCKET}"
    exit 1
  fi
  echo 'AWS permissions validated'
}


function create_soloball() {
  $BERKS package -b "${BERKSFILE_PATH}" "${DEPLOY_ARTIFACT_PATH}"
}

function deploy_artifacts() {
  echo 'Uploading artifacts...'
  # Upload this timestamped tarball
#  $AWSCLI --profile cpe-tools --region us-west-2 s3 cp "${DEPLOY_ARTIFACT_PATH}" ${DEPLOY_S3_ARTIFACT}
  $AWSCLI --region us-west-2 s3 cp "${DEPLOY_ARTIFACT_PATH}" ${DEPLOY_S3_ARTIFACT}
  # Copy timestamped tarball to cookbooks-latest.tar.gz
#  $AWSCLI --profile cpe-tools --region us-west-2 s3 cp ${DEPLOY_S3_ARTIFACT} ${DEPLOY_BUCKET}/cookbooks-latest.tar.gz
  $AWSCLI --region us-west-2 s3 cp ${DEPLOY_S3_ARTIFACT} ${DEPLOY_BUCKET}/cookbooks-latest.tar.gz

  echo 'artifacts successfully deployed'
}

test_prereqs
echo "Using AWS profile '${AWS_PROFILE}'"
test_aws_permissions
create_soloball
deploy_artifacts
