#!/usr/bin/env ruby
require 'mixlib/cli'
require 'dropbox_api'

TEAMCITY_DROPBOX_OAUTH2 = ENV['TEAMCITY_DROPBOX_OAUTH2'].freeze

class Options
    include Mixlib::CLI
  
    option :build_platform,
      :short => "-p PLATFORM",
      :long  => "--platform PLATFORM",
      :required => true
  
    option :build_number,
      :short => "-n NUMBER",
      :long  => "--number NUMBER",
      :required => true
  
    option :build_region,
      :short => "-r region",
      :long  => "--region REGION",
      :required => false

    option :build_type,
      :short => "-t TYPE",
      :long  => "--type TYPE",
      :required => true,
      :proc => Proc.new { |l| l.downcase }

    option :manual_build,
      :short => "-m",
      :long  => "--manual",
      :required => false,
      :default => false,
      :boolean => true

    option :build_branch,
      :short => "-b BRANCH",
      :long  => "--branch BRANCH",
      :required => true

    option :file_glob,
      :short => "-g GLOB",
      :long  => "--glob GLOB",
      :required => true

end

cli = Options.new
cli.parse_options

cli.config[:build_type] = 'manualbuilds' if cli.config[:manual_build]
cli.config[:build_branch] = cli.config[:build_branch].gsub('/', '_')

dropbox = DropboxApi::Client.new(TEAMCITY_DROPBOX_OAUTH2)

folder_base = '/automatedbuilds'

path = File.join(
    folder_base,
    cli.config[:build_platform],
    cli.config[:build_type],
    "#{cli.config[:build_branch]}_#{cli.config[:build_number]}"
)

path << "/#{cli.config[:build_region]}" if cli.config[:build_region]

filename = Dir.glob(cli.config[:file_glob])[0]

File.open(filename) do |f|
    dropbox.upload_by_chunks(File.join(path, filename), f)
end

# link = "https://www.dropbox.com/home#{folder_base}/#{cli.config[:build_platform]}/#{cli.config[:build_number]}/#{cli.config[:build_region]}/#{filename}"
# puts "##teamcity[buildStatus status='SUCCESS' text='{build.status.text}#{cli.config[:build_region]}: #{link}\\n']"