include_recipe 'sds_teamcity::agent'

directory '/csi/packages' do
  recursive true
end

%w(
  /Windows/system32/config/systemprofile
  /Users/teamcity
  /Users/cpe
).each do |user_home|
  next unless File.exists?(user_home)
  directory "#{user_home}/.ssh" do
    mode 0700
  end

  file "#{user_home}/.ssh/twitch-ghe-read-key" do
    content arcana_read('twitch-ghe-read-key')
    mode 0600
  end

  file "#{user_home}/.ssh/csi-svc-github.com" do
    content arcana_read('csi-svc-github.com')
    mode 0600
  end

  file "#{user_home}/.ssh/config" do
    content <<-EOF
  Host *
    ServerAliveInterval 300
    ServerAliveCountMax 2

  Host git-aws.internal.justin.tv
    StrictHostKeyChecking no
    UserKnownHostsFile /dev/null
    HostName git-aws.internal.justin.tv
    IdentityFile ~/.ssh/twitch-ghe-read-key

  Host git.xarth.tv
    StrictHostKeyChecking no
    UserKnownHostsFile /dev/null
    HostName git.xarth.tv
    IdentityFile ~/.ssh/twitch-ghe-read-key

  Host github.com
    StrictHostKeyChecking no
    UserKnownHostsFile /dev/null
    HostName github.com
    IdentityFile ~/.ssh/csi-svc-github.com
    EOF
    mode 0600
  end
end

chocolatey_package 'git-lfs'

execute 'git-enable-lfs' do
  command '"C:\Program Files\Git\bin\git.exe" lfs install --system'
end

execute 'git-enable-lfs-cmd' do
  command '"C:\Program Files\Git\cmd\git.exe" lfs install --system'
end

directory '/opt/scripts' do
  recursive true
end

s3_gem 'dropbox_api' do
  version '0.1.11'
  gem_binary 'C:\opscode\chef\embedded\bin\gem'
end

cookbook_file '/opt/scripts/teamcity-dropbox-upload.rb' do
  source 'teamcity-dropbox-upload.rb'
  mode 0755
end

registry_key 'HKEY_LOCAL_MACHINE\SYSTEM\ControlSet001\Control\FileSystem' do
  values [{name: 'LongPathsEnabled', type: :dword, data: 1}]
  action :create
end

registry_key 'HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\FileSystem' do
  values [{name: 'LongPathsEnabled', type: :dword, data: 1}]
  action :create
end

execute 'git-enable-long-filenames' do
  command '"C:\Program Files\Git\bin\git.exe" config --system core.longpaths true'
end

execute 'git-set-user-email' do
  command '"C:\Program Files\Git\bin\git.exe" config --global user.email "csi-devops@justin.tv"'
end

execute 'git-set-user-name' do
  command '"C:\Program Files\Git\bin\git.exe" config --global user.name "CSI TeamCity"'
end

execute 'git-enable-long-filenames-cmd' do
  command '"C:\Program Files\Git\cmd\git.exe" config --system core.longpaths true'
end

execute 'git-set-user-email-cmd' do
  command '"C:\Program Files\Git\cmd\git.exe" config --global user.email "csi-devops@justin.tv"'
end

execute 'git-set-user-name-cmd' do
  command '"C:\Program Files\Git\cmd\git.exe" config --global user.name "CSI TeamCity"'
end

cookbook_file '/windows/system32/sandstorm.exe' do
  source 'sandstorm_binary'
end

cookbook_file '/windows/syswow64/sandstorm.exe' do
  source 'sandstorm_binary'
end
