tag 'teamcity_androidsdk_agent'
node.default['teamcity']['agent']['env_properties']['ANDROIDSDK_AGENT'] = 1

chocolatey_package 'android-ndk'

chocolatey_package 'android-sdk'

powershell_script 'accept_sdk_licenses' do
    code <<-EOH
        C:\\Android\\android-sdk\\tools\\bin\\sdkmanager --update
        $x = for ($i = 0; $i -lt 100; $i++) { echo 'y' }; $x | C:\\Android\\android-sdk\\tools\\bin\\sdkmanager --licenses
        If ($LASTEXITCODE -eq 0) {
            $true
        } Else {
            exit 1212
        }
    EOH
end

apis = %w(
    platforms;android-16
    platforms;android-19
    platforms;android-21
    platforms;android-22
    platforms;android-23
    platforms;android-24
    platforms;android-25
    platforms;android-26
    platforms;android-27
    platforms;android-28
    platforms;android-29
).each do |api_level|
    powershell_script "install_#{api_level.gsub(/;/, '_')}" do
        code <<-EOH
            c:\\Android\\android-sdk\\tools\\bin\\sdkmanager \"#{api_level}\"
            If ($LASTEXITCODE -eq 0) {
                $true
            } Else {
                exit 1212
            }
        EOH
    end
end
