# install python/conan for C/C++ dependency management
chocolatey_package 'python' do
  version '2.7.11'
  options '--side-by-side'
end

chocolatey_package 'python' do
  version '3.7.5'
  options '--side-by-side'
end

windows_path 'C:\\tools\\python\\' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'c:\\tools\\python\\Scripts\\' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'C:\\Python37\\' do
  action :remove
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'c:\\Python37\\Scripts\\' do
  action :remove
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

execute 'python_file_association_1' do
  command 'assoc .py=PythonScript'
end

execute 'python_file_association_2' do
  command 'ftype PythonScript="c:\tools\\python\python.exe" "%1" %*'
end

reboot 'reboot_after_path_change' do
  action :nothing
  delay_mins 1
end
