tag 'teamcity_ps4sdk_agent'
node.default['teamcity']['agent']['env_properties']['PS4SDK_AGENT'] = 1

powershell_script 'install_dot_net_3-5' do
  code <<-EOH
    Install-WindowsFeature -name NET-Framework-Core
  EOH
  not_if <<-EOH
    (Get-WindowsFeature -name NET-Framework-Core).Installed
  EOH
end

chocolatey_package 'strawberryperl' do
  version '5.26.2.1'
end

chocolatey_package 'cmake' do
  version '3.16.0'
end

windows_path 'C:\\Program Files\\CMake\\bin' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

gem_package 'ruby_protobuf' do
  gem_binary 'C:\opscode\chef\embedded\bin\gem'
end

gem_package 'faraday' do
  gem_binary 'C:\opscode\chef\embedded\bin\gem'
end

gem_package 'faraday_middleware' do
  gem_binary 'C:\opscode\chef\embedded\bin\gem'
end

execute 'ruby_file_association_1' do
  command 'assoc .rb=RubyScript'
end

execute 'ruby_file_association_2' do
  command 'ftype RubyScript="c:\opscode\chef\embedded\bin\ruby.exe" "%1" %*'
end

chocolatey_package 'python' do
  version '2.7.11'
  options '--side-by-side'
end

chocolatey_package 'python' do
  version '3.7.5'
  options '--side-by-side'
end

windows_path 'C:\\tools\\python\\' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'c:\\tools\\python\\Scripts\\' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'C:\\Python37\\' do
  action :remove
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'c:\\Python37\\Scripts\\' do
  action :remove
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

execute 'python_file_association_1' do
  command 'assoc .py=PythonScript'
end

execute 'python_file_association_2' do
  command 'ftype PythonScript="c:\tools\\python\python.exe" "%1" %*'
end

# this is the last version of pip that works with python2
# version 21 of pip drops support for python2
execute 'python_update_pip' do
  command 'c:\\tools\\python\\scripts\\pip.exe install pip==20.3.4'
end

execute 'python_update_setuptools' do
  command 'c:\\tools\\python\\scripts\\pip.exe install setuptools -U'
end

execute 'install_gitpython' do
  command 'c:\\tools\\python\\scripts\\pip.exe install "gitpython<3.0"'
end

execute 'install_boto3' do
  command 'c:\\tools\\python\\scripts\\pip.exe install boto3'
end

execute 'python3_update_pip' do
  command 'c:\\Python37\\scripts\\pip.exe install pip -U'
end

execute 'python3_update_setuptools' do
  command 'c:\\Python37\\scripts\\pip.exe install setuptools -U'
end

execute 'python3_install_gitpython' do
  command 'c:\\Python37\\scripts\\pip.exe install gitpython'
end

execute 'python3_install_boto3' do
  command 'c:\\Python37\\scripts\\pip.exe install boto3'
end

reboot 'reboot_after_path_change' do
  action :nothing
  delay_mins 1
end

## This doesn't work at least with SDK 4.500, quiet mode still requires interaction
# directory '/csi/packages/ps4sdk/'

# s3_file "/csi/packages/ps4_sdk_4.500_pkg1.zip" do
#   key 'ps4_sdk/ps4_sdk_4.500_pkg1.zip'
#   checksum '99b1e121b9375dd34c62dcd8783c75db493ca2c6bba9040b324c10c9e6912479'
#   not_if {::File.exists?('c:/csi/packages/ps4_sdk_4.500_pkg1.zip')}
# end

# windows_zipfile 'c:/csi/packages' do
#   source '/csi/packages/ps4_sdk_4.500_pkg1.zip'
#   action :unzip
#   not_if {::File.exists?('c:/csi/packages/ps4sdk/SDK_Manager.exe')}
#   notifies :run, 'execute[install_ps4sdk]'
# end

# execute 'install_ps4sdk' do
#   command 'c:/csi/packages/ps4sdk/SDK_Manager.exe /quiet /NORESTART /log=c:\temp'
#   action :nothing
#   notifies :request_reboot, 'reboot[ps4sdk_restart]'
# end

# reboot 'ps4sdk_restart' do
#   delay_mins 1
#   reason 'PS4 SDK Installed'
#   action :nothing
# end
