set_role_tag
include_recipe 'base_server_windows'

node.default['teamcity']['agent']['user_password'] = arcana_read('teamcity_user_password').strip
include_recipe '::agent'

include_recipe '::reboot_partial'
include_recipe '::vs2017_partial'
include_recipe '::choco_python'
include_recipe '::spotlight_partial'
include_recipe '::sigcheck'

chocolatey_package 'nodejs-lts' do
  version '14.16.1'
  retries 3
  retry_delay 30
end

chocolatey_package 'yarn' do
  version '1.12.3'
end

# llvm/clang for clang-format tool
chocolatey_package 'llvm' do
  version '8.0.1'
end

chocolatey_package 'doxygen.install' do
  version '1.8.15'
end

chocolatey_package 'graphviz' do
  version '2.38.0.20190211'
end

chocolatey_package 'opencppcoverage' do
  version '0.9.7.0'
end

chocolatey_package 'typescript' do
  version '3.5.2'
end

chocolatey_package 'jq' do
  version '1.5'
end

chocolatey_package 'nuget.commandline' do
  version '5.1.0'
end

chocolatey_package 'cmake' do
  version '3.20.2'
end

execute 'npm install ts-node' do
  command 'c:\\"Program Files"\\nodejs\\npm.cmd install -g ts-node@8.3.0'
end
