tag 'teamcity_uwp_agent'
node.default['teamcity']['agent']['env_properties']['UWP_AGENT'] = 1

powershell_script 'install_dot_net_3-5' do
  code <<-EOH
    Install-WindowsFeature -name NET-Framework-Core
  EOH
  not_if <<-EOH
    (Get-WindowsFeature -name NET-Framework-Core).Installed
  EOH
end

chocolatey_package 'strawberryperl' do
  version '5.26.2.1'
end

chocolatey_package 'cmake' do
  version '3.16.0'
end

windows_path 'C:\\Program Files\\CMake\\bin' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

gem_package 'ruby_protobuf' do
  gem_binary 'C:\opscode\chef\embedded\bin\gem'
end

gem_package 'faraday' do
  gem_binary 'C:\opscode\chef\embedded\bin\gem'
end

gem_package 'faraday_middleware' do
  gem_binary 'C:\opscode\chef\embedded\bin\gem'
end

execute 'ruby_file_association_1' do
  command 'assoc .rb=RubyScript'
end

execute 'ruby_file_association_2' do
  command 'ftype RubyScript="c:\opscode\chef\embedded\bin\ruby.exe" "%1" %*'
end

chocolatey_package 'python' do
  version '2.7.11'
  options '--side-by-side'
end

chocolatey_package 'python' do
  version '3.7.5'
  options '--side-by-side'
end

# Update pip for both version of python
# this is the last version of pip that works with python2
# version 21 of pip drops support for python2
execute 'update python 2.7 pip' do
  command 'c:\\tools\\python\\scripts\\pip.exe install pip==20.3.4'
end

execute 'update python 3 pip' do
  command 'c:\\tools\python\\Scripts\\pip.exe install -U pip'
end

windows_path 'C:\\tools\\python\\' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'c:\\tools\\python\\Scripts\\' do
  action :add
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'C:\\Python37\\' do
  action :remove
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

windows_path 'c:\\Python37\\Scripts\\' do
  action :remove
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

execute 'python_file_association_1' do
  command 'assoc .py=PythonScript'
end

execute 'python_file_association_2' do
  command 'ftype PythonScript="c:\tools\\python\python.exe" "%1" %*'
end

execute 'python_update_setuptools' do
  command 'c:\\tools\\python\\scripts\\pip.exe install setuptools -U'
end

execute 'install_gitpython' do
  command 'c:\\tools\\python\\scripts\\pip.exe install "gitpython<3.0"'
end

directory '/csi/packages/XboxOnePlatformExtensionSDK'

s3_file 'XboxOnePlatformExtensionSDK' do
  path '/csi/packages/XboxOnePlatformExtensionSDK/XboxOnePlatformExtensionSDK.zip'
  key 'XboxOnePlatformExtensionSDK/rs4_release_xbox_dev_1806_17134.4056.180626-1359_XboxOnePlatformExtensionSDK.zip'
end

powershell_script 'extract_platform_extensions' do
  code "Expand-Archive /csi/packages/XboxOnePlatformExtensionSDK/XboxOnePlatformExtensionSDK.zip -DestinationPath ."
  cwd '/csi/packages/XboxOnePlatformExtensionSDK'
  not_if { File.exist?('/csi/packages/XboxOnePlatformExtensionSDK/XboxOnePlatformExtensionSDK.exe') }
  notifies :run, 'execute[install_xbox_extensions]'
end

execute 'install_xbox_extensions' do
  command 'c:\csi\packages\XboxOnePlatformExtensionSDK\XboxOnePlatformExtensionSDK.exe /q'
  cwd '/csi/packages/XboxOnePlatformExtensionSDK'
  action :nothing
  notifies :request_reboot, 'reboot[reboot_after_path_change]'
end

reboot 'reboot_after_path_change' do
  action :nothing
  delay_mins 1
end
