#
# Cookbook Name:: base-server
# Recipe:: ubuntu-admins
#
# Copyright (c) 2015 Curse, All Rights Reserved.

# Make sure we actually have a sudo group
# :create alone wipes all users and breaks vagrant
group 'wheel' do
  guard_interpreter :bash
  not_if 'grep -q "^wheel:" /etc/group'
end

lib_cpe_user 'kaelten' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'mclemore' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'tbriggs' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'aluff' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'jhhartsh' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'thohanso' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'mdreyfus' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'andaries' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'bwilliams' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'jukenned' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'newhalld' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'royberg' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'kimglen' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'hvr' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'johnalb' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'margibs' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'richduar' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'seungyou' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'picong' do
  action :delete
  ignore_failure true
end

lib_cpe_user 'fkastne' do
  action :delete
  ignore_failure true
end if shadow?

## Ensure 'curse' and 'ubuntu' temporary users are deleted as soon as possible
#   unless we're in test kitchen
if !ENV['TEST_KITCHEN']
  %w( curse ec2-user ).each do |user|
    user user do
      action :remove
      ignore_failure true
    end
  end
else
  execute "usermod -p '*' ec2-user"
end
