#
# Cookbook:: base_server_amazon
# Recipe:: default
#
# Copyright:: 2018, Twitch, All Rights Reserved.

package %w( autoconf bison flex gcc gcc-c++ gettext kernel-devel make m4 ncurses-devel patch zlib-devel ruby-devel rubygems )
package %w( gcc44 gcc44-c++ ) unless (node['platform_version'] == '2' || (node['release'] && node['release'].include?('amzn2')))

include_recipe 'ntp'
include_recipe 'openssh'
include_recipe 'sudo'

if (node['platform_version'] == '2' || (node['release'] && node['release'].include?('amzn2')))
  include_recipe '::dns' if node['dnsmasq']['enable']
end

include_recipe '::admins'
# include_recipe '::monitoring' # legacy sensu package is no longer available
# include_recipe '::logging' # csi syslog infra this used has been shut down
include_recipe '::cloudwatch'
include_recipe '::iptables'

include_recipe 'chef-client::config'

file '/etc/chef/client.d/syslog.rb' do
  content "log_location Chef::Log::Syslog.new('chef-client', ::Syslog::LOG_DAEMON)\n"
  mode 0644
  notifies :create, 'ruby_block[reload_client_config]'
end

cron 'run_chef' do
  minute '*/15'
  command 'PATH=$PATH:/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin /usr/local/bin/chef-run'
  only_if {File.exists?('/usr/local/bin/chef-run')}
end

service 'chef-client' do
  supports status: true, restart: true
  action [:disable, :stop]
end

