package 'dnsmasq'

template '/etc/dnsmasq.d/listen.conf' do
  source 'listen.conf.erb'
  notifies_immediately :restart, 'service[dnsmasq]'
end

template '/etc/dnsmasq.d/dns.conf' do
  source 'dns.conf.erb'
  notifies_immediately :restart, 'service[dnsmasq]'
end if node['dnsmasq']['server']

file '/etc/resolv.dnsmasq' do
  content <<-EOH
    nameserver 169.254.169.253
  EOH
end

service 'dnsmasq' do
  action [:enable, :start]
end

execute 'update-dhclient' do
  command '/usr/sbin/dhclient'
  action :nothing
end

file '/etc/dhcp/dhclient.conf' do
  content <<-EOH
    supersede domain-name-servers 127.0.0.1;
    timeout 300;
  EOH
  notifies :run, 'execute[update-dhclient]', :delayed
end
