if node["logging"]["filebeat"]["enabled"]
  # if enabled (default) install and configure normally
  filebeat_install 'default' do
    version '6.3.0'
    action :create
  end

  message_conf = {
    'enabled' => true,
    'ignore_older' => '25h',
    'close_timeout' => '24h',
    'paths' => ['/var/log/messages'],
    'type' => 'log',
    'fields' => {'log_type' => 'syslog'},
  }
  
  filebeat_prospector 'messages_log' do
    config message_conf
    action :create
  end

  auth_conf = {
    'enabled' => true,
    'ignore_older' => '25h',
    'close_timeout' => '24h',
    'paths' => ['/var/log/secure'],
    'type' => 'log',
    'fields' => {'log_type' => 'auth'},
  }
  
  filebeat_prospector 'auth_log' do
    config auth_conf
    action :create
  end

  filebeat_conf = {
    'filebeat.modules' => [],
    'logging.level' => 'info',
    'logging.to_files' => true,
    'logging.files' => { 'name' => 'filebeat' },
    'output.logstash' => { 'hosts' => node['logstash']['url']},
  }  

  filebeat_config 'default' do
    config filebeat_conf
    action :create
  end

  filebeat_service 'default' do
    action :create
  end
else
  # if not enabled, delete service, configurations, and uninstall filebeat
  # filebeat_service 'default' do
  #   action :delete
  # end

  # filebeat_install 'default' do
  #   action :delete
  # end

  # THE ABOVE filebeat_service and filebeat_install deletions do not work
  # recreating the same steps below to perform the same operations
  service 'filebeat' do
    action [:stop, :disable]
  end

  package 'filebeat' do
    action :remove
  end

  directory '/etc/filebeat' do
    action :delete
    recursive true
  end

  directory '/var/log/filebeat' do
    action :delete
    recursive true
  end
end
