## Install

include_recipe 'sensu'

execute 'systemctl daemon-reload' do
  action :nothing
end

# These files get created on AL1, but they don't do anything.
directory '/etc/systemd/system/sensu-client.service.d' do
  recursive true
  action :create
end

template '/etc/systemd/system/sensu-client.service.d/override.conf' do
  source 'sensu-client.service.override.conf.erb'
  mode 00644
  helper(:sensu) { node['sensu'] }
  notifies :run, 'execute[systemctl daemon-reload]', :immediately if is_al2?
  notifies :restart, 'sensu_service[sensu-client]', :delayed
  action :create
end

sensu_gem 'sensu-transport-snssqs-ng'

sensu_snippet "snssqs" do
    content node['sensu']['common_config']['snssqs']
end

sensu_client node.name do
    address node['cloud']['local_ipv4']
    subscriptions []
    additional node['sensu']['client_options']
end

include_recipe 'sensu::client_service'

s3_gem 'sensu-extension-tueor' do
  version '0.3.0'
  gem_binary '/opt/sensu/embedded/bin/gem'
  notifies :restart, 'sensu_service[sensu-client]', :delayed
end

directory '/etc/sensu/secrets' do
    owner node['sensu']['user']
    group node['sensu']['group']
    mode 700
end


## Checks

base_server_amazon_extension_check 'memory-check' do
  extension 'linux-memory-check'
  source 'linux-memory-check.rb'
  occurrences 15 * 6 # 15 minutes
  handlers node['sensu']['client_options']['extensions']['handlers']
end

base_server_amazon_extension_check 'swap-check' do
  extension 'linux-memoryswap-check'
  source 'linux-memoryswap-check.rb'
  occurrences 15 * 6 # 15 minutes
  handlers node['sensu']['client_options']['extensions']['handlers']
end

base_server_amazon_extension_check 'zombie-process-check' do
  extension 'linux-zombieprocs-check'
  source 'linux-zombieprocs-check.rb'
  handlers node['sensu']['client_options']['extensions']['handlers']
end

base_server_amazon_extension_check 'root-disk-check' do
  extension 'linux-diskspace-check'
  source 'linux-diskspace-check.rb'
  extra_options({ mountpoint: '/' })
  handlers node['sensu']['client_options']['extensions']['handlers']
end

## Probably should combine these 2 resources into a library
directory '/.readonly_fs_test' do
  owner 'sensu'
  mode 0700
end

base_server_amazon_extension_check 'root-disk-readonly-check' do
  extension 'linux-disk-readonly-check'
  source 'linux-disk-readonly-check.rb'
  extra_options({ folder: '/.readonly_fs_test' })
  handlers node['sensu']['client_options']['extensions']['handlers']
end

## Scripts

cookbook_file '/etc/cron.d/sensu_check.rb' do
  source 'sensu-check.rb'
  owner 'root'
  group 'root'
  mode '0644'
end

cron 'sensu-check' do
  command '/usr/bin/ruby /etc/cron.d/sensu_check.rb'
end
