default_action :setup

#core configuration
property :name, :kind_of => String, :name_attribute => true
property :source, :kind_of => String
property :extension, :kind_of => String
property :handlers, :kind_of => Array, :default => ['pagerduty']

property :type, :kind_of => String, :equal_to => %w(standard metric), :default => 'standard'
property :extension_cookbook, :kind_of => String, :default => nil

# These seem like reasonable defaults, I think
property :interval, :kind_of => Integer, :default => 10
property :timeout, :kind_of => Integer, :default => 60 * 10
property :ttl, :kind_of => Integer, :default => 60 * 30

# Checks will only be handled by a sensu-plugin based handler if there's :occurrences in the last :refresh seconds
property :occurrences, :kind_of => Integer, :default => 2
property :refresh, :kind_of => Integer, :default => 1800

# Handle should be true, if it's false events raised from it will not be forwarded to handlers even if they're specified
property :handle, :kind_of => [TrueClass, FalseClass], :default => true

property :warning_threshold, :kind_of => [Float, Integer], :required => false
property :critical_threshold, :kind_of => [Float, Integer], :required => false
property :extra_options, :kind_of => Hash
property :arcana_options, :kind_of => Hash

action :setup do

  data = {
      :extension => new_resource.extension,
      :type => new_resource.type,
      :standalone => true,
      :interval => new_resource.interval,
      :timeout => new_resource.timeout,
      :ttl => new_resource.ttl,
      :handle => new_resource.handle,
      :handlers => new_resource.handlers,
      :occurrences => new_resource.occurrences,
      :refresh => new_resource.refresh,
  }

  new_resource.extra_options.each do |k, v|
    if data[k]
      raise "You can't specify an extra_option called #{k}"
    end
    data[k] = v
  end if new_resource.extra_options

  serialized = { new_resource.name => data }

  cookbook_file new_resource.name do
    source "sensu/#{new_resource.source}"
    cookbook new_resource.extension_cookbook unless new_resource.extension_cookbook.nil?
    path ::File.join(node['sensu']['directory'], 'extensions', new_resource.source)
    owner node['sensu']['user']
    group node['sensu']['group']
    mode 00750
    notifies :restart, 'service[sensu-client]',  :delayed
  end

  file "sensu/checks/#{new_resource.name}.json" do
    path ::File.join(node['sensu']['directory'], 'conf.d', "#{new_resource.name}.json")
    content JSON.pretty_generate(:checks => serialized)

    owner node['sensu']['user']
    group node['sensu']['group']
    mode 00640

    notifies :restart, 'service[sensu-client]',  :delayed
  end

  file "sensu/secrets/#{new_resource.name}.json" do
    path ::File.join(node['sensu']['directory'], 'secrets', "#{new_resource.name}.json")
    content JSON.pretty_generate(Hash[new_resource.arcana_options.map{|k,v| [k, arcana_read(v)]}])
    owner node['sensu']['user']
    group node['sensu']['group']
    mode 00600
    notifies :restart, 'service[sensu-client]',  :delayed
  end if new_resource.arcana_options

end

action :delete do
  file new_resource.name do
    path ::File.join(node['sensu']['directory'], 'extensions', new_resource.source)
    action :delete
    notifies :restart, 'service[sensu-client]',  :delayed
  end

  file "sensu/checks/#{new_resource.name}.json" do
    path ::File.join(node['sensu']['directory'], 'conf.d', "#{new_resource.name}.json")
    action :delete
    notifies :restart, 'service[sensu-client]',  :delayed
  end

  file "sensu/secrets/#{new_resource.name}.json" do
    path ::File.join(node['sensu']['directory'], 'secrets', "#{new_resource.name}.json")
    action :delete
    notifies :restart, 'service[sensu-client]',  :delayed
  end
end