default['macos']['time_zone'] = 'GMT'

unless ENV['TEST_KITCHEN']
    default['macos']['admin_user'] = 'csi'
    default['homebrew']['owner'] = 'csi'
    default['sensu']['common_config']['snssqs']['publishing_sns_topic_arn'] = "arn:aws:sns:us-west-2:994136867826:sensu_ingress"
    default['sensu']['common_config']['snssqs']['region'] = 'us-west-2'
else
    default['homebrew']['owner'] = 'vagrant'
    default['sensu']['common_config']['snssqs']['publishing_sns_topic_arn'] = "arn:aws:sns:us-west-1:432112285195:sensu_ingress"
    default['sensu']['common_config']['snssqs']['region'] = 'us-west-1'
end

node.default['authorization']['sudo']['sudoers_defaults'] = [
    'env_reset',
    'env_keep += "BLOCKSIZE"',
    'env_keep += "COLORFGBG COLORTERM"',
    'env_keep += "__CF_USER_TEXT_ENCODING"',
    'env_keep += "CHARSET LANG LANGUAGE LC_ALL LC_COLLATE LC_CTYPE"',
    'env_keep += "LC_MESSAGES LC_MONETARY LC_NUMERIC LC_TIME"',
    'env_keep += "LINES COLUMNS"',
    'env_keep += "LSCOLORS"',
    'env_keep += "TZ"',
    'env_keep += "DISPLAY XAUTHORIZATION XAUTHORITY"',
    'env_keep += "EDITOR VISUAL"',
    'env_keep += "HOME MAIL"'
  ]

default["sensu"]["version"] = "1.7.0-1"
default['sensu']['use_ssl'] = false

default["sensu"]["user"] = '_sensu'
default["sensu"]["group"] = '_sensu'

default['sensu']['transport']['name'] = 'snssqs'
default['sensu']['transport']['reconnect_on_error'] = true

default['sensu']['client_options'] = Mash.new
default['sensu']['client_options']['keepalive']['thresholds']['warning'] = 150
default['sensu']['client_options']['keepalive']['thresholds']['critical'] = 300
default['sensu']['client_options']['keepalive']['handler'] = 'pagerduty'
default['sensu']['client_options']['http_socket']['port'] = 13031

default['sensu']['client_options']['os'] = node['os']
default['sensu']['client_options']['os_version'] = node['os_version']
default['sensu']['client_options']['platform'] = node['platform']
default['sensu']['client_options']['platform_version'] = node['platform_version']
default['sensu']['client_options']['platform_family'] = node['platform_family']

default["sensu"]["redis"] = nil
default["sensu"]["api"] = nil
