# Ignore the man behind the curtain ...
# Quick monkeypatch to rewrite the _linux sensu installer to a local macos one

# If https://github.com/sensu/sensu-chef starts supporting macOS or this case statement
#  https://github.com/sensu/sensu-chef/blob/develop/recipes/default.rb#L28-L35 doesn't include
#  the _linux recipe (or that doesn't cause an exception on macOS) remove this and ::_sensu
class Chef
    class RunContext
        def include_recipe(*recipe_names, current_cookbook: nil)
            result_recipes = Array.new
            recipe_names.flatten.each do |recipe_name|
              if recipe_name == 'sensu::_linux'
                recipe_name = 'base_server_macos::_sensu'
              end
              if result = load_recipe(recipe_name, current_cookbook: current_cookbook)
                result_recipes << result
              end
            end
            result_recipes
        end
    end
end
