#
# Cookbook:: base_server_macos
# Recipe:: default
#
# Copyright:: 2018, Twitch, All Rights Reserved.


include_recipe 'macos::disable_software_updates'
include_recipe 'macos::keep_awake'

build_essential 'Install Xcode CLI Tools' do
    compile_time true
end

execute 'disable_login_screensaver' do
    command 'defaults write /Library/Preferences/com.apple.screensaver loginWindowIdleTime 0'
    not_if 'defaults read /Library/Preferences/com.apple.screensaver loginWindowIdleTime | egrep -q "^0$"'
end

include_recipe 'homebrew'

group 'homebrew' do
    not_if "grep -q 'homebrew:' /etc/group"
end

homebrew_package 'zsh'

cookbook_file '/etc/profile' do
    source 'profile'
end

include_recipe '::admins'
include_recipe '::monitoring'
include_recipe '::dnsmasq'

execute 'fix brew permissions' do
    command <<-EOH
    chgrp -R homebrew /usr/local/*
    chmod -R g+w /usr/local/*
    EOH
end