override['chef_client']['config']['ssl_ca_file'] = '/etc/chef/opsworks-cm-ca-root.pem' unless ENV['TEST_KITCHEN']

override['authorization']['sudo']['groups'] = ['sudo']
override['authorization']['sudo']['passwordless'] = true
override['authorization']['sudo']['include_sudoers_d'] = true

override['authorization']['sudo']['sudoers_defaults'] = [
    '!visiblepw',
    'env_reset',
    'env_keep =  "COLORS DISPLAY HOSTNAME HISTSIZE INPUTRC KDEDIR LS_COLORS"',
    'env_keep += "MAIL PS1 PS2 QTDIR USERNAME LANG LC_ADDRESS LC_CTYPE"',
    'env_keep += "LC_COLLATE LC_IDENTIFICATION LC_MEASUREMENT LC_MESSAGES"',
    'env_keep += "LC_MONETARY LC_NAME LC_NUMERIC LC_PAPER LC_TELEPHONE"',
    'env_keep += "LC_TIME LC_ALL LANGUAGE LINGUAS _XKB_CHARSET XAUTHORITY"',
    'env_keep += "HOME"',
    'always_set_home',
    'secure_path="/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin"'
]

override['openssh']['config_mode'] = 0600
override['openssh']['root_group'] = 'root'

override['openssh']['server']['password_authentication'] = 'no'
override['openssh']['server']['use_p_a_m'] = 'no'

override['openssh']['server']['subsystem'] = 'sftp internal-sftp'
override['openssh']['server']['match']['Group sftponly'] = {
    :force_command => 'internal-sftp',
    :chroot_directory => '/chroot/%u',
    :allow_tcp_forwarding => 'no',
    :password_authentication => 'yes'
}

override['git']['version'] = '1:2.29.0-0ppa1~ubuntu16.04.1'
override['git-man']['version'] = '1:2.29.0-0ppa1~ubuntu16.04.1'

override['openssh']['server']['protocol'] = '2'
override['openssh']['server']['banner'] = '/etc/issue'
override['openssh']['server']['log_level'] = 'INFO'
override['openssh']['server']['x11_forwarding'] = 'no'
override['openssh']['server']['max_auth_tries'] = '4'
override['openssh']['server']['ignore_rhosts'] = 'yes'
override['openssh']['server']['hostbased_authentication'] = 'no'
override['openssh']['server']['permit_root_login'] = 'no'
override['openssh']['server']['permit_empty_passwords'] = 'no'
override['openssh']['server']['permit_user_environment'] = 'no'
override['openssh']['server']['ciphers'] = 'aes128-ctr,aes192-ctr,aes256-ctr'

# CIS 9.3.12 - Enforce Idle Timeouts
override['openssh']['server']['client_alive_interval'] = 600
override['openssh']['server']['client_alive_count_max'] = 0

# CIS 9.3.13 - Limit SSH Access
override['openssh']['server']['allow_groups'] = 'sudo'

override['ntp']['restrictions'] = [
    '-4 default kod nomodify notrap nopeer noquery'
]

default['dnsmasq']['server'] = nil
default['dnsmasq']['listen-address'] = '127.0.0.1'

unless node['platform'] == 'mac_os_x'
  default['sensu']['common_config']['transport']['name'] = 'snssqs'
  default['sensu']['common_config']['transport']['reconnect_on_error'] = true
  default['sensu']['common_config']['snssqs']['publishing_sns_topic_arn'] = "arn:aws:sns:#{get_region}:#{get_aws_account}:sensu_ingress"
  default['sensu']['common_config']['snssqs']['region'] = get_region
  default['sensu']['client_config']['keepalive']['thresholds']['warning'] = 150
  default['sensu']['client_config']['keepalive']['thresholds']['critical'] = 300
  default['sensu']['client_config']['keepalive']['handler'] = 'pagerduty'
  default['sensu']['client_config']['public_hostname'] = node['cloud']['public_hostname']
  default['sensu']['client_config']['instance_id'] = node['ec2']['instance_id']

  default['sensu']['client_config']['os'] = node['os']
  default['sensu']['client_config']['os_version'] = node['os_version']
  default['sensu']['client_config']['platform'] = node['platform']
  default['sensu']['client_config']['platform_version'] = node['platform_version']
  default['sensu']['client_config']['platform_family'] = node['platform_family']
end

# LOGGING
# CloudWatch Agent attributes
default["logging"]["cloudwatch_agent"]["enabled"] = true
default["logging"]["cloudwatch_agent"]["log_group"] = 'syslog_default' # override this per-environment
default["logging"]["cloudwatch_agent"]['package']["url"] = "https://s3.amazonaws.com/amazoncloudwatch-agent/ubuntu/amd64/latest/amazon-cloudwatch-agent.deb"
default["logging"]["cloudwatch_agent"]['package']["checksum"] = nil # disabled while we're using latest
default["logging"]["cloudwatch_agent"]['package']["path"] = ::File.join(Chef::Config[:file_cache_path], 'amazon-cloudwatch-agent.deb')
# Filebeat + Logstash attributes
default["logging"]["filebeat"]["enabled"] = true
override['logstash']['url'] = 'forwarder.syslog-prod.twitch.cloud:5033'
