include_recipe 'apt'

# Speed up unattended upgrades on first run at the expense of potential issues if interrupted
node.override['apt']['unattended_upgrades']['minimal_steps'] = false unless ::File.exists?('/etc/apt/.first_run_upgrade')

include_recipe 'apt::unattended-upgrades'

execute 'apt-get update' do
  command 'apt-get update'
end

# Adds entries in /etc/apt/preferences.d/ for each package in the run_list with a version specified
# #  needs to happen here so unattended-upgrades doesn't install something we don't want
apt_pin 'Pin Packages'

# Run security updates on first boot
execute 'apt-get security updates' do
  command '/usr/bin/unattended-upgrade'
  notifies :create, 'file[apt-upgrade-lock]'
  not_if { ::File.exists?('/etc/apt/.first_run_upgrade') }
end

file 'apt-upgrade-lock' do
  path '/etc/apt/.first_run_upgrade'
  action :nothing
end
