#
# Cookbook:: base_server_ubuntu
# Recipe:: cloudwatch
#
# Copyright:: 2020, Twitch, All Rights Reserved.

# Install and configure the Cloudwatch Agent for handling syslog
# Step 1: Is cloudwatch agent and logging enabled for this node?
if node["logging"]["cloudwatch_agent"]["enabled"]
  # Step 1: If enabled, install the CloudWatch Agent
  # Download the installer
  remote_file 'amazon-cloudwatch-agent' do
    path node["logging"]["cloudwatch_agent"]['package']["path"]
    source node["logging"]["cloudwatch_agent"]['package']['url']
    checksum node["logging"]["cloudwatch_agent"]['package']['checksum']
    mode 0644
  end

  # Install the pakage
  package 'amazon-cloudwatch-agent' do
    source node["logging"]["cloudwatch_agent"]['package']['path']
    provider Chef::Provider::Package::Dpkg
  end

  # Step 2: Add our custom configuration file
  # There are other ways to load configuration for CloudWatch Agent, but this is
  # the most straightforward. This speical json file is read every time the
  # service restarts.
  template '/opt/aws/amazon-cloudwatch-agent/etc/amazon-cloudwatch-agent.json' do
    source 'amazon-cloudwatch-agent.json.erb'
    notifies_immediately :restart, 'service[amazon-cloudwatch-agent]'
  end

  # Step 3: Run.
  service 'amazon-cloudwatch-agent' do
    action [:enable, :start]
  end
else
  # Step -1: If not enabled, handle the teardown of CloudWatch Agent
  service 'amazon-cloudwatch-agent' do
    action [:stop, :disable]
  end  

  package 'amazon-cloudwatch-agent' do
    action :remove
  end
end

