#
# Cookbook:: base_server_ubuntu
# Recipe:: default
#
# Copyright:: 2017, Curse, All Rights Reserved.

Chef.event_handler do
  on :run_completed do
    CPE::Helpers.send_sensu_payload 'chef-client-heartbeat', 'chef-client-heartbeat OK', 0
  end

  on :run_failed do |exception|
    CPE::Helpers.send_sensu_payload 'chef-client-heartbeat', exception.message, 1
  end
end

include_recipe "#{cookbook_name}::apt"
include_recipe "#{cookbook_name}::git"

include_recipe 'ntp'
include_recipe 'openssh'
include_recipe 'sudo'

package 'dnsmasq'

template '/etc/dnsmasq.d/listen.conf' do
  source 'listen.conf.erb'
  notifies_immediately :restart, 'service[dnsmasq]'
end

template '/etc/dnsmasq.d/dns.conf' do
  source 'dns.conf.erb'
  notifies_immediately :restart, 'service[dnsmasq]'
end if node['dnsmasq']['server']

service 'dnsmasq' do
  action [:enable, :start]
end

include_recipe "#{cookbook_name}::admins"
#include_recipe "#{cookbook_name}::ssm_agent"

# include_recipe "#{cookbook_name}::monitoring" # legacy sensu package is no longer available
include_recipe "#{cookbook_name}::logging"
include_recipe "#{cookbook_name}::cloudwatch"
include_recipe "#{cookbook_name}::iptables"

include_recipe 'chef-client::config'

file '/etc/chef/client.d/syslog.rb' do
  content "log_location Chef::Log::Syslog.new('chef-client', ::Syslog::LOG_DAEMON)\n"
  mode 0644
  notifies :create, 'ruby_block[reload_client_config]'
end

cron 'run_chef' do
  minute '*/15'
  command 'PATH=$PATH:/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin /usr/local/bin/chef-run'
  only_if {File.exists?('/usr/local/bin/chef-run') && !node['disable_chef_cron']}
end

service 'chef-client' do
  supports status: true, restart: true
  action [:disable, :stop]
end

