
include_recipe 'sds_sensu'

package 'make'
package 'gcc'
package 'g++'

s3_gem 'sensu-extension-tueor' do
  version '0.2.0'
  gem_binary '/opt/sensu/embedded/bin/gem'
  notifies :restart, 'service[sensu-client]', :delayed
end

sds_sensu_extension_check 'memory-check' do
  extension 'linux-memory-check'
  source 'linux-memory-check.rb'
  occurrences 15 * 6 # 15 minutes
end

sds_sensu_extension_check 'swap-check' do
  extension 'linux-memoryswap-check'
  source 'linux-memoryswap-check.rb'
  occurrences 15 * 6 # 15 minutes
end

sds_sensu_extension_check 'zombie-process-check' do
  extension 'linux-zombieprocs-check'
  source 'linux-zombieprocs-check.rb'
end

sds_sensu_extension_check 'root-disk-check' do
  extension 'linux-diskspace-check'
  source 'linux-diskspace-check.rb'
  extra_options({ mountpoint: '/' })
end

## Probably should combine these 2 resources into a library
directory '/.readonly_fs_test' do
  owner 'sensu'
  mode 0700
end

sds_sensu_extension_check 'root-disk-readonly-check' do
  extension 'linux-disk-readonly-check'
  source 'linux-disk-readonly-check.rb'
  extra_options({ folder: '/.readonly_fs_test' })
end

## Scripts

cookbook_file '/etc/cron.d/sensu_check.rb' do
  source 'sensu-check.rb'
  owner 'root'
  group 'root'
  mode '0644'
end

cron 'sensu-check' do
  command '/usr/bin/ruby /etc/cron.d/sensu_check.rb'
end
