# Download the installer
# @since 0.1.0
remote_file 'amazon-ssm-agent' do
  path node['ssm_agent']['package']['path']
  source node['ssm_agent']['package']['url']
  checksum node['ssm_agent']['package']['checksum']
  mode 0644
end

# Install the pakage
# @since 0.1.0
package 'amazon-ssm-agent' do
  source node['ssm_agent']['package']['path']
  provider value_for_platform_family(
               'rhel' => Chef::Provider::Package::Yum,
               'debian' => Chef::Provider::Package::Dpkg
           )
end

# Ensure service state
# @since 0.1.0
service node['ssm_agent']['service']['name'] do
  action node['ssm_agent']['service']['actions']
end

logrotate_app 'amazon-ssm-agent' do
  path %w(
    /var/log/amazon/ssm/amazon-ssm-agent.log
    /var/log/amazon/ssm/errors.log
  )
  rotate node['ssm_agent']['logrotate']['rotate']
  frequency node['ssm_agent']['logrotate']['frequency']
  postrotate node['ssm_agent']['logrotate']['postrotate']
  template_mode '0644'
end