try {

    function Test-PendingReboot {
     if (Get-ChildItem "HKLM:\Software\Microsoft\Windows\CurrentVersion\Component Based Servicing\RebootPending" -EA Ignore) { return $true }
     if (Get-Item "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\WindowsUpdate\Auto Update\RebootRequired" -EA Ignore) { return $true }
     #if (Get-ItemProperty "HKLM:\SYSTEM\CurrentControlSet\Control\Session Manager" -Name PendingFileRenameOperations -EA Ignore) { return $true }
     try {
       $util = [wmiclass]"\\.\root\ccm\clientsdk:CCM_ClientUtilities"
       $status = $util.DetermineIfRebootPending()
       if(($status -ne $null) -and $status.RebootPending){
         return $true
       }
     }catch{}

     return $false
    }

    if ($(Test-PendingReboot)) {
        Write-Host "Warning: Reboot required to complete updates"
        exit 1
    }

    Write-Host "OK: No reboot required"
    exit 0

} catch {
    Write-Host "UNKNOWN: $_.Exception.Message"
    exit 3
}
