## Install

include_recipe 'sensu'

sensu_gem 'sensu-transport-snssqs-ng'

sensu_snippet "snssqs" do
    content node['sensu']['common_config']['snssqs']
end

sensu_client node.name do
    address node['cloud']['local_ipv4']
    subscriptions []
    additional node['sensu']['client_options']
end

include_recipe 'sensu::client_service'

sensu_gem 'sensu-plugin'
sensu_gem 'sensu-plugins-windows'


## Standard Checks

sensu_check 'disk-check-windows' do
  command 'c:\\opt\\sensu\\embedded\\bin\\ruby C:\\opt\\sensu\\embedded\\bin\\powershell_helper.rb check-windows-disk.ps1 90 95'
  standalone true
  handlers ['pagerduty']
  interval  30
end

sensu_check 'cpu-check-windows' do
  command 'c:\\opt\\sensu\\embedded\\bin\\ruby C:\\opt\\sensu\\embedded\\bin\\powershell_helper.rb check-windows-cpu-load.ps1 90 95'
  standalone true
  interval  30
  additional(:occurrences => 10)
end

sensu_check 'memory-check-windows' do
  command 'c:\\opt\\sensu\\embedded\\bin\\ruby C:\\opt\\sensu\\embedded\\bin\\powershell_helper.rb check-windows-ram.ps1 90 95'
  standalone true
  interval  30
  additional(:occurrences => 10)
end

cookbook_file '/etc/sensu/plugins/reboot_required.ps1' do
  source 'sensu/reboot_required.ps1'
end

sensu_check 'pending-reboot-check' do
  command 'C:\\Windows\\System32\\WindowsPowershell\\v1.0\\powershell.exe -NoProfile -File /etc/sensu/plugins/reboot_required.ps1'
  standalone true
  interval 86400
  ttl 86400 * 3
  timeout 30
  additional(:occurrences => 1)
end