property :version, :kind_of => String, :required => true
property :gem_binary, :kind_of => String
property :ttl, :kind_of => Integer
property :options, :kind_of => [String, Hash]
property :bucket, kind_of: String, default: 'generic-packages-default-uswest2-6d6c0de383565712c723c750188799'


default_action :install
provides :s3_gem

download_path = node['platform'].eql?('windows') ? '/src' : '/usr/local/src'

action :install do
  gem_filename = "#{new_resource.name}-#{new_resource.version}.gem"

  directory download_path

  s3_file "#{download_path}/#{gem_filename}" do
    key "gems/#{new_resource.name}/#{gem_filename}"
    bucket new_resource.bucket
    owner 'root' unless node['platform'].eql?('windows')
    mode 0500
    notifies :install, "gem_package[#{new_resource.name}]", :immediately
  end

  g = gem_package new_resource.name do
    gem_binary new_resource.gem_binary if new_resource.gem_binary
    version new_resource.version
    source "#{download_path}/#{gem_filename}"
    options new_resource.options
    timeout new_resource.ttl if new_resource.ttl
    action :nothing
  end

  new_resource.updated_by_last_action(g.updated_by_last_action?)
end

action :upgrade do
  gem_filename = "#{new_resource.name}-#{new_resource.version}.gem"

  s3_file "#{download_path}/#{gem_filename}" do
    key "gems/#{new_resource.name}/#{gem_filename}"
    bucket new_resource.bucket
    owner 'root' unless node['platform'].eql?('windows')
    mode 0500 unless node['platform'].eql?('windows')
    notifies :upgrade, "gem_package[#{new_resource.name}]", :immediately
  end

  g = gem_package new_resource.name do
    gem_binary new_resource.gem_binary if new_resource.gem_binary
    version new_resource.version
    source "#{download_path}/#{gem_filename}"
    options new_resource.options
    timeout new_resource.ttl if new_resource.ttl
    action :nothing
  end

  new_resource.updated_by_last_action(g.updated_by_last_action?)
end

action :remove do
  gem_filename = "#{new_resource.name}-#{new_resource.version}.gem"

  s3_file "#{download_path}/#{gem_filename}" do
    key "gems/#{new_resource.name}/#{gem_filename}"
    bucket new_resource.bucket
    owner 'root' unless node['platform'].eql?('windows')
    mode 0500 unless node['platform'].eql?('windows')
    action :remove
  end

  g = gem_package new_resource.name do
    gem_binary new_resource.gem_binary if new_resource.gem_binary
    version new_resource.version
    source "#{download_path}/#{gem_filename}"
    options new_resource.options
    timeout new_resource.ttl if new_resource.ttl
    action :remove
  end

  new_resource.updated_by_last_action(g.updated_by_last_action?)
end